/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.recipes.quern.QuernRecipe;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.te.TEInventory;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class TEQuern
extends TEInventory
implements ITickable {
    public static final int SLOT_HANDSTONE = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    private int rotationTimer = 0;
    private boolean hasHandstone;

    public TEQuern() {
        super(3);
    }

    public ItemStack insertOrSwapItem(int slot, ItemStack playerStack) {
        ItemStack quernStack = this.inventory.getStackInSlot(slot);
        if (quernStack.func_190926_b() || playerStack.func_77985_e() && quernStack.func_77985_e() && quernStack.func_77973_b() == playerStack.func_77973_b() && (!playerStack.func_77981_g() || playerStack.func_77960_j() == quernStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)playerStack, (ItemStack)quernStack)) {
            return this.inventory.insertItem(slot, playerStack, false);
        }
        this.inventory.setStackInSlot(slot, playerStack);
        return quernStack;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot == 0 ? 1 : 64;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return OreDictionaryHelper.doesStackMatchOre(stack, "handstone");
            }
            case 1: {
                return QuernRecipe.get(stack) != null;
            }
        }
        return false;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.markForBlockUpdate();
        if (slot == 0) {
            this.hasHandstone = OreDictionaryHelper.doesStackMatchOre(this.inventory.getStackInSlot(0), "handstone");
        }
        super.setAndUpdateSlots(slot);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.rotationTimer = nbt.func_74762_e("rotationTimer");
        super.func_145839_a(nbt);
        this.hasHandstone = OreDictionaryHelper.doesStackMatchOre(this.inventory.getStackInSlot(0), "handstone");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("rotationTimer", this.rotationTimer);
        return super.func_189515_b(nbt);
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return super.canInteractWith(player) && this.rotationTimer == 0;
    }

    public int getRotationTimer() {
        return this.rotationTimer;
    }

    public boolean isGrinding() {
        return this.rotationTimer > 0;
    }

    public boolean hasHandstone() {
        return this.hasHandstone;
    }

    public void grind() {
        this.rotationTimer = 90;
        this.markForBlockUpdate();
    }

    public void func_73660_a() {
        if (this.rotationTimer > 0) {
            --this.rotationTimer;
            if (this.rotationTimer == 0) {
                this.grindItem();
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187704_k, SoundCategory.BLOCKS, 1.0f, 0.8f);
                this.inventory.getStackInSlot(0).func_77972_a(1, (EntityLivingBase)new EntityCow(this.field_145850_b));
                if (this.inventory.getStackInSlot(0).func_190926_b()) {
                    for (int i = 0; i < 15; ++i) {
                        this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.875, (double)this.field_174879_c.func_177952_p() + 0.5, (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) / 4.0, this.field_145850_b.field_73012_v.nextDouble() / 4.0, (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) / 4.0, new int[]{Item.func_150891_b((Item)ItemsTFC.HANDSTONE)});
                    }
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 1.0f, 0.8f);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 0.6f);
                }
                this.setAndUpdateSlots(0);
            }
        }
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 2, 1));
    }

    private void grindItem() {
        QuernRecipe recipe;
        ItemStack inputStack = this.inventory.getStackInSlot(1);
        if (!inputStack.func_190926_b() && (recipe = QuernRecipe.get(inputStack)) != null && !this.field_145850_b.field_72995_K) {
            inputStack.func_190918_g(((IIngredient)recipe.getIngredients().get(0)).getAmount());
            ItemStack outputStack = recipe.getOutputItem(inputStack);
            outputStack = this.inventory.insertItem(2, outputStack, false);
            this.inventory.setStackInSlot(2, CapabilityFood.mergeItemStacksIgnoreCreationDate(this.inventory.getStackInSlot(2), outputStack));
            if (!outputStack.func_190926_b()) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (ItemStack)outputStack);
            }
        }
    }
}

